% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcuref.R
\name{rcuref}
\alias{rcuref}
\title{Title Generate Sample with Cure Fraction}
\usage{
rcuref(rdistrX, param_X, n = 10000, p = 0.5)
}
\arguments{
\item{rdistrX}{sample generator of distribution X. \cr First argument number of samples, next arguments in param_X.}

\item{param_X}{list with parameters of rdistrX function.}

\item{n}{number of sample to create.}

\item{p}{cure fraction}
}
\value{
A list with sample data information: \tabular{ll}{
   \code{data_cf}\tab vector of cure fraction sample.\cr
   \code{cure_list} \tab vector of 1 and 0 indicating whether the i-th sample is cured. \cr
    \tab 1:= cure , 0:= no cure \cr
   \code{cure_fraction} \tab cure fraction used to create de sample. \cr
   \tab \cr
}
}
\description{
Generator Sample with Cure Fraction,
 given a generator of samples of the distribution X (rdistrX) with
 parameters appended by the list param_X. Also the proportion of cure desired p.
}
\examples{
#Example Exponential Cure Fraction p = 0.5

Data = rcuref(rdistrX = rexp, param_X = list("rate" = 1),
              n = 1000, p = 0.5)
}
\author{
Daniel Saavedra Morales
}
