% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcdk.R
\name{get.largest.component}
\alias{get.largest.component}
\title{Gets the largest component in a disconnected molecular graph.}
\usage{
get.largest.component(mol)
}
\arguments{
\item{mol}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}
}
\value{
The largest component as an `IAtomContainer` object or else the input molecule itself
}
\description{
A molecule may be represented as a
\href{http://mathworld.wolfram.com/DisconnectedGraph.html}{disconnected graph}, such as
when read in as a salt form. This method will return the larges connected component
or if there is only a single component (i.e., the molecular graph is
\href{https://en.wikipedia.org/wiki/Complete_graph}{complete} or fully connected), that
component is returned.
}
\examples{
m <- parse.smiles("CC.CCCCCC.CCCC")[[1]]
largest <- get.largest.component(m)
length(get.atoms(largest)) == 6
}
\seealso{
\code{\link{is.connected}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
