% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rbmi-settings}
\alias{rbmi-settings}
\alias{set_options}
\title{rbmi settings}
\usage{
set_options()
}
\description{
Define settings that modify the behaviour of the \code{rbmi} package

Each of the following are the name of options that can be set via:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(<option_name> = <value>)
}\if{html}{\out{</div>}}
\subsection{\code{rbmi.cache_dir}}{

Default = \code{tempfile()}

Directory to store compiled Stan models in to avoid having to re-compile.
If the environment variable \code{RBMI_CACHE_DIR} has been set this will be used
as the default value.
Note that if you are running rbmi in multiple R processes at the same time
(that is say multiple calls to \code{Rscript} at once) then there is a theoretical
risk of the processes breaking each other as they attempt to read/write to the
same cache folder at the same time. To avoid this potential issue it is recommended
to leave this value at the default which will result in a unique cache for each
process
}

\subsection{\code{rbmi.enable_cache}}{

Default = \code{TRUE}

If \code{TRUE} then the package will attempt to cache compiled Stan models to the
\code{rbmi.cache_dir} directory. If \code{FALSE} then the package will re-compile the
Stan model each time it is required. If the environment variable \code{RBMI_ENABLE_CACHE}
has been set this will be used as the default value.
}
}
\examples{
\dontrun{
options(rbmi.cache_dir = "some/directory/path")
options(rbmi.enable_cache = FALSE)
}
}
