% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm25_score.R
\name{bm25_score}
\alias{bm25_score}
\title{Score a text corpus based on the Okapi BM25 algorithm}
\usage{
bm25_score(data, query, lang = NULL, k1 = 1.2, b = 0.75)
}
\arguments{
\item{data}{text data, a vector of strings. Note any preprocessing steps
(tolower, removing stopwords etc) need to have taken place before this!}

\item{query}{the term to search for, note all preprocessing that was
applied to the text corpus initially needs to be already performed on
the term, e.g., tolower, removing stopwords etc}

\item{lang}{language of the data, see self$available_languages(),
can also be "detect" to automatically detect the language,  default is "detect"}

\item{k1}{k1 parameter of BM25, default is 1.2}

\item{b}{b parameter of BM25, default is 0.75}
}
\value{
a numeric vector of the BM25 scores, note higher values are showing
a higher relevance of the text to the query
}
\description{
A simple wrapper around the \link{BM25} class.
}
\examples{
corpus <- c(
 "The rabbit munched the orange carrot.",
 "The snake hugged the green lizard.",
 "The hedgehog impaled the orange orange.",
 "The squirrel buried the brown nut."
)
scores <- bm25_score(data = corpus, query = "orange")
data.frame(text = corpus, scores_orange = scores)
}
\seealso{
\link{BM25}
}
