% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{ramps}
\alias{ramps}
\alias{gradinv}
\title{Color gradient ramps}
\usage{
gradinv(n)
}
\arguments{
\item{n}{(\code{numeric}) Number of different colors to generate from the palette}
}
\value{
A character vector of color values.
}
\description{
Contains functions produced by the \code{\link[grDevices:colorRamp]{colorRampPalette}} function.
}
\details{
You can also view single palettes individually. The following color palettes are implemented:
\itemize{
\item \code{gradinv()}: inverse heatmap, primarily intended to emphasize distinctions between no-change (yellow) and change (blue/red) cases.
Based on the color blindness simulator Coblis, the palette is very color disability-friendly, except for monochromacy/achromatopsia, where the two change scenarios (red and blue) become very difficult to distinguish.
Additional markings (e.g. labels indicating high and low) are recommended for these cases.
}
}
\examples{
cols <- gradinv(20)
plot(1:20, col=cols, pch=16, cex=2)
}
