% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{Feature-Constructors}
\alias{Feature-Constructors}
\alias{makeRawSource}
\alias{makeLocalScavenger}
\title{Making Source Objects}
\usage{
makeRawSource(ncolumns)

makeLocalScavenger(theModelFeatures, name)
}
\arguments{
\item{ncolumns}{number of features this constructor should manage, thought of
as columns of the design matrix.}

\item{theModelFeatures}{other features currently in the model.}

\item{name}{name of the base feature with which to create interactions.}
}
\value{
A closure containing a list of functions.
}
\description{
These functions create and manage the features to test. The raw
  source only tests marginal features (the covariates in the design matrix)
  while the scavenger source tests for interactions between a base feature
  and those features already in the model. makeLocalScavenger builds on
  makeRawSource. Defaults are not set because these are internal functions
  called by \code{\link{rai}} and \code{\link{runAuction}} and all arguments
  are required.
}
