% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-azure.R
\name{embed_azure_openai}
\alias{embed_azure_openai}
\title{Uses Azure AI Foundry to create embeddings}
\usage{
embed_azure_openai(
  x,
  endpoint = get_envvar("AZURE_OPENAI_ENDPOINT"),
  api_key = get_envvar("AZURE_OPENAI_API_KEY"),
  api_version = "2023-05-15",
  model,
  batch_size = 20L,
  api_args = list()
)
}
\arguments{
\item{x}{x can be:
\itemize{
\item A character vector, in which case a matrix of embeddings is returned.
\item A data frame with a column named \code{text}, in which case the dataframe is
returned with an additional column named \code{embedding}.
\item Missing or \code{NULL}, in which case a function is returned that can be called
to get embeddings. This is a convenient way to partial in additional arguments like \code{model},
and is the most convenient way to produce a function that can be passed to the \code{embed} argument of \code{ragnar_store_create()}.
}}

\item{endpoint}{The Azure AI Foundry endpoint URL. A URI in the form of
\verb{https://<project>.cognitiveservices.azure.com/}. Defaults to the value
of the \code{AZURE_OPENAI_ENDPOINT} environment variable.
This URL is appended with \verb{/openai/deployments/\{model\}/embeddings}.
Where \code{model} is the deployment name of the model.}

\item{api_key}{resolved using env var \code{OPENAI_API_KEY}}

\item{api_version}{The API version to use. Defaults to \code{2023-05-15}.}

\item{model}{The deployment name of the model to use for generating embeddings.}

\item{batch_size}{split \code{x} into batches when embedding. Integer, limit of
strings to include in a single request.}

\item{api_args}{A list of additional arguments to pass to the API request body.}
}
\value{
If \code{x} is a character vector, then a numeric matrix is returned,
where \code{nrow = length(x)} and \verb{ncol = <model-embedding-size>}. If \code{x} is a
data.frame, then a new \code{embedding} matrix "column" is added, containing the
matrix described in the previous sentence.

A matrix of embeddings with 1 row per input string, or a dataframe with an 'embedding' column.
}
\description{
Uses Azure AI Foundry to create embeddings
}
