% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-databricks.R
\name{embed_databricks}
\alias{embed_databricks}
\title{Embed text using a Databricks model}
\usage{
embed_databricks(
  x,
  workspace = databricks_workspace(),
  model = "databricks-bge-large-en",
  batch_size = 512L
)
}
\arguments{
\item{x}{x can be:
\itemize{
\item A character vector, in which case a matrix of embeddings is returned.
\item A data frame with a column named \code{text}, in which case the dataframe is
returned with an additional column named \code{embedding}.
\item Missing or \code{NULL}, in which case a function is returned that can be called
to get embeddings. This is a convenient way to partial in additional arguments like \code{model},
and is the most convenient way to produce a function that can be passed to the \code{embed} argument of \code{ragnar_store_create()}.
}}

\item{workspace}{The URL of a Databricks workspace, e.g.
\code{"https://example.cloud.databricks.com"}. Will use the value of the
environment variable \code{DATABRICKS_HOST}, if set.}

\item{model}{The name of a text embedding model.}

\item{batch_size}{split \code{x} into batches when embedding. Integer, limit of
strings to include in a single request.}
}
\description{
\code{\link[=embed_databricks]{embed_databricks()}} gets embeddings for text using a model hosted in a
Databricks workspace. It relies on the \pkg{ellmer} package for managing
Databricks credentials. See \code{\link[ellmer:chat_databricks]{ellmer::chat_databricks}} for more on
supported modes of authentication.
}
