% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maplot.R
\name{maplot}
\alias{maplot}
\title{Bland Altman plot aka MA plot}
\usage{
maplot(
  x,
  y,
  n = 10000,
  subset = NULL,
  xlab = NULL,
  ylab = NULL,
  curve.add = TRUE,
  curve.col = 2,
  curve.span = 1/2,
  curve.lwd = 2,
  curve.n = 2000,
  ...
)
}
\arguments{
\item{x}{a numeric vector}

\item{y}{a numeric vector}

\item{n}{a numeric value. If \code{length(x)} is larger than \code{n}, the \code{x} and \code{y} are sampled down.}

\item{subset}{index of the points to be plotted}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{curve.add}{if \code{TRUE} a smooth curve is fit to the data and displayed. The function \code{\link{loess}} is used to fit the curve.}

\item{curve.col}{a numeric value that determines the color of the smooth curve}

\item{curve.span}{is passed on to \code{\link{loess}} as the \code{span} argument}

\item{curve.lwd}{the line width for the smooth curve}

\item{curve.n}{a numeric value that determines the sample size used to fit the curve. This makes fitting the curve faster with large datasets}

\item{...}{further arguments passed to \code{\link{plot}}}
}
\description{
Takes two vectors x and y and plots 
M=y-x versus A=(x+y)/2. 
If the vectors a more longer than length n the data is sampled to size n. 
A smooth curve is added to show trends.
}
\examples{
n <- 10000
signal <- runif(n,4,15)
bias <- (signal/5 - 2)^2 
x <- signal + rnorm(n)
y <- signal + bias + rnorm(n)  
maplot(x,y)

}
\author{
Rafael A. Irizarry
}
