% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{precision.intrinsicCBrSPDEobj}
\alias{precision.intrinsicCBrSPDEobj}
\title{Get the precision matrix of intrinsicCBrSPDEobj objects}
\usage{
\method{precision}{intrinsicCBrSPDEobj}(
  object,
  kappa = NULL,
  tau = NULL,
  alpha = NULL,
  beta = NULL,
  ld = FALSE,
  ...
)
}
\arguments{
\item{object}{The model object computed using \code{\link[=intrinsic.matern.operators]{intrinsic.matern.operators()}}}

\item{kappa}{If non-null, update the range parameter.}

\item{tau}{If non-null, update the precision parameter.}

\item{alpha}{If non-null, update the alpha parameter.}

\item{beta}{If non-null, update the beta parameter.}

\item{ld}{If TRUE, return the log determinant of the precision matrix instead
of the precision matrix. By default FALSE.}

\item{...}{Currently not used.}
}
\value{
The precision matrix.
}
\description{
Function to get the precision matrix of a intrinsicCBrSPDEobj object
}
\examples{
if (requireNamespace("RSpectra", quietly = TRUE)) {
  x <- seq(from = 0, to = 10, length.out = 201)
  beta <- 1
  alpha <- 1
  kappa <- 1
  op <- intrinsic.matern.operators(
    kappa = kappa, tau = 1, alpha = alpha,
    beta = beta, loc_mesh = x, d = 1
  )
Q <- precision(op) 
}
}
\seealso{
\code{\link[=simulate.intrinsicCBrSPDEobj]{simulate.intrinsicCBrSPDEobj()}}, \code{\link[=intrinsic.matern.operators]{intrinsic.matern.operators()}}
}
