% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairTDP.R
\name{pairTDP}
\alias{pairTDP}
\title{pairwise true discoveries proportion}
\usage{
pairTDP(mps, n, gCT)
}
\arguments{
\item{mps}{Matrix or vector of pairwise associations.}

\item{n}{Number of pairs; may not be the size of p if a threshold is used to remove large p-values.}

\item{gCT}{Parameters of the global closed testing, output of simesCT function.}
}
\value{
Proportion of true discoveries out of n pairs of features.
}
\description{
Calculates the TDP over pairs; based on SEA algorithm
}
\examples{

#number of features per omic data set
n_cols<-100
n_rows<-120

#random matrix of p-values
set.seed(1258)
pvalmat<-matrix(runif(n_rows*n_cols, min=0, max=1)^5, nrow=n_rows, ncol=n_cols)

#calculate CT parameters
gCT<-simesCT(mps=pvalmat, m=nrow(pvalmat)*ncol(pvalmat))

#define the two-way feature set
subpmat<-pvalmat[61:80,26:50]

#calculate pairwise TDP for feature set
pairTDP(subpmat, n=nrow(subpmat)*ncol(subpmat), gCT)

}
\seealso{
\link[rSEA]{SEA}, \link{simesCT}
}
