% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{climate_input}
\alias{climate_input}
\title{Climate Input Function}
\usage{
climate_input(
  tmax = NULL,
  tmin = NULL,
  prec = NULL,
  wind = NULL,
  dates = NULL,
  base.range = c(1961, 1990),
  n = 5,
  quantiles = NULL,
  temp.qtiles = c(0.1, 0.9),
  wind.qtile = 0.9,
  max.missing.days = c(annual = 15, monthly = 3),
  min.base.data.fraction.present = 0.1
)
}
\arguments{
\item{tmax}{Numeric vector. Maximum temperature data.}

\item{tmin}{Numeric vector. Minimum temperature data.}

\item{prec}{Numeric vector. Precipitation data.}

\item{wind}{Numeric vector. Wind speed data.}

\item{dates}{Date vector. Dates corresponding to the data.}

\item{base.range}{Numeric vector of length 2. Base range years for calculations (default is c(1961, 1990)).}

\item{n}{Integer. Window size for running averages (default is 5).}

\item{quantiles}{List. Pre-calculated quantiles (optional).}

\item{temp.qtiles}{Numeric vector. Temperature quantiles to calculate (default is c(0.10, 0.90)).}

\item{wind.qtile}{Numeric. Wind quantile to calculate (default is 0.90).}

\item{max.missing.days}{Named numeric vector. Maximum allowed missing days for annual and monthly data (default is c(annual = 15, monthly = 3)).}

\item{min.base.data.fraction.present}{Numeric. Minimum fraction of data required in base range (default is 0.1).}
}
\value{
A list containing processed data and related information for climate index calculations.
}
\description{
Processes climate data and calculates necessary statistics for climate index calculations.
}
\examples{
\donttest{
# 1. Generate a daily date sequence from 1960-01-01 to 2020-12-31
dates <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-31"),
  by   = "day"
)

# 2. Create random weather data for each date
n <- length(dates)
tmax <- runif(n, min = 5, max = 40)
tmin <- runif(n, min = -10,  max = 5)
# Example: use a Poisson distribution to simulate precipitation
prec <- rpois(n, lambda = 2)
# Random wind speeds, e.g., 0 to 10 m/s
wind <- runif(n, min = 0, max = 10)

# 3. Construct the climate_input object
ci <- climate_input(
  tmax  = tmax,
  tmin  = tmin,
  prec  = prec,
  wind  = wind,
  dates = dates
)

# 4. Examine the structure of ci
str(ci)
}
}
