% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decodeLDA.R
\name{decodeLDA}
\alias{decodeLDA}
\title{Implement \code{DECODE} for simple LDA}
\usage{
decodeLDA(X, y, lambda0 = NULL, ...)
}
\arguments{
\item{X}{\eqn{n\times p}{nxp} data matrix.}

\item{y}{binary \eqn{n}-length vector containing the class of each observation.}

\item{lambda0}{number between 0 and 1. If \code{NULL}, will use \eqn{\sqrt{2 \log{p}/n}}{\sqrt2logp/n}.}

\item{...}{additional arguments to be passed to general decode function.}
}
\value{
An object of class \code{decodeLDA} containing:
  \item{eta}{\code{DECODE} of \eqn{\Omega\delta}}
  \item{X}{training data used}
  \item{y}{training label used}
and various outputs from \code{decode} function.
}
\description{
Implement \code{DECODE} for simple LDA. The LDA assumes both classes have equal prior probabilities. This implementation is used in Hadimaja and Pun (2018).
}
\examples{
# for efficiency, we will only use 500 variables

# load the training data (Lung cancer data, cleaned)
data(lung.train) # 145 x 1578
X.train <- lung.train[,1:500]
y.train <- lung.train[,1578]

# build the DECODE
object <- decodeLDA(X.train, y.train)

object
summary(object)
coef(object)

# test on test data
data(lung.test)
X.test <- lung.test[,1:500]
y.test <- lung.test[,1578]
y.pred <- predict(object, X.test)
table(y.pred, y.test)

}
\references{
Hadimaja, M. Z., & Pun, C. S. (2018). A Self-Calibrated Regularized Direct Estimation for Graphical Selection and Discriminant Analysis.
}
