% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\name{assayMelt}
\alias{assayMelt}
\title{Melt Assay Dataset}
\usage{
assayMelt(assay.df, exp.name)
}
\arguments{
\item{assay.df}{Imported data.frame consisting of the following columns: 'ID','Lot', and columns identifying the Day, Operator and Replicate like so: 'D1_Op2_3' to indicate Day 1, operator 2, replicate 3.}

\item{exp.name}{Experiment name (as a string). To be used to distinguish between experiments for when melted assays are combined using rbind().}
}
\value{
A melted data.frame
}
\description{
This function is a wrapper for the reshape2::melt() function and splits column of Day, Operator, and Replicate information into 3 separate columns.
}
\examples{
assay.df.melted <- assayMelt(assay.df = lognormAssay, exp.name = 'Experiment1')
head(assay.df.melted)

}
\author{
Emma Gail
}
