% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_MSALinearity.R
\name{gageLin}
\alias{gageLin}
\title{gageLin: Function to visualize and calucalte the linearity of a gage.}
\usage{
gageLin(
  object,
  conf.level = 0.95,
  ylim,
  col,
  pch,
  lty = c(1, 2),
  stats = TRUE,
  plot = TRUE
)
}
\arguments{
\item{object}{An object of class \code{MSALinearity} containing the data and model for the linearity analysis. To create such an object see \code{gageLinDesign}.}

\item{conf.level}{A numeric value between `0` and `1`, giving the confidence intervall for the analysis.
Default value: `0.95`.}

\item{ylim}{A numeric vector of length 2 specifying the y-axis limits for the plot. If not specified, the limits are set automatically based on the data.}

\item{col}{A vector with four numeric entries. The first gives the color of the single points, the second gives the color of the points for the mean bias, the third gives the color fo the straight interpolation line and the fourth gives the color for the lines representing the confidence interval. If one of the values is missing or negative the points or lines are not plotted. col is by default `c(1,2,1,4)`.}

\item{pch}{A vector with two numeric or single character entries giving the symbols for the single points (1st entry) and the mean bias (2nd entry). The default vector is `c(20,18)`}

\item{lty}{a vector with two entries giving the line-style for the interpolating line and the confidence interval lines. For detailed information to the entries please see par. The default value for lty is `c(1,2)`.}

\item{stats}{Logical value. If `TRUE` (default) the function returns all calculated information.}

\item{plot}{Logical value indicating whether to generate a plot of the linearity analysis. Default is \code{TRUE}.}
}
\value{
The function returns an object of class \code{MSALinearity} which can be used with e.g. \code{plot} or \code{summary}.
}
\description{
Function visualize the linearity of a gage by plotting the single and mean bias in one plot and intercalate them with a straight line.
Furthermore the function deliver some characteristic values of linearity studies according to MSA (Measurement System Analysis).
}
\examples{
# Results of single runs
A=c(2.7,2.5,2.4,2.5,2.7,2.3,2.5,2.5,2.4,2.4,2.6,2.4)
B=c(5.1,3.9,4.2,5,3.8,3.9,3.9,3.9,3.9,4,4.1,3.8)
C=c(5.8,5.7,5.9,5.9,6,6.1,6,6.1,6.4,6.3,6,6.1)
D=c(7.6,7.7,7.8,7.7,7.8,7.8,7.8,7.7,7.8,7.5,7.6,7.7)
E=c(9.1,9.3,9.5,9.3,9.4,9.5,9.5,9.5,9.6,9.2,9.3,9.4)

# create Design
test=gageLinDesign(ref=c(2,4,6,8,10),n=12)
# create data.frame for results
results=data.frame(rbind(A,B,C,D,E))
# enter results in Design
test$response(results)
test$summary()

# no plot and no return
MSALin=gageLin(test,stats=FALSE,plot=FALSE)

# plot only
plot(MSALin)
MSALin$plot()

# summary
MSALin$summary()
}
\seealso{
\code{\link{cg}}, \code{\link{gageRR}}, \code{\link{gageLinDesign}}, \code{\link{MSALinearity}}.
}
