% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_Factorial_designs_Classes.R
\name{desirability.c}
\alias{desirability.c}
\title{desirability-class: Class `desirability`}
\description{
A class representing the desirability metrics for responses in a design.
}
\seealso{
\code{\link{desirability}}, \code{\link{overall}}, \code{\link{optimum}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{response}}{A numeric vector specifying the responses for which desirability is calculated.}

\item{\code{low}}{A numeric vector representing the lower bounds of the desirable range for each response.}

\item{\code{high}}{A numeric vector representing the upper bounds of the desirable range for each response.}

\item{\code{target}}{A numeric vector or character string indicating the target values or goals for each response.}

\item{\code{scale}}{A numeric vector specifying the scaling factors used in the desirability calculation.}

\item{\code{importance}}{A numeric vector indicating the importance of each response in the desirability calculation.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-desirability.c-new}{\code{desirability.c$new()}}
\item \href{#method-desirability.c-print}{\code{desirability.c$print()}}
\item \href{#method-desirability.c-plot}{\code{desirability.c$plot()}}
\item \href{#method-desirability.c-clone}{\code{desirability.c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desirability.c-new"></a>}}
\if{latex}{\out{\hypertarget{method-desirability.c-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new \code{desirability.c} object with specified parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desirability.c$new(
  response = NULL,
  low = NULL,
  high = NULL,
  target = NULL,
  scale = NULL,
  importance = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{A numeric or character vector specifying the responses for which desirability is calculated.}

\item{\code{low}}{A numeric vector representing the lower bounds of the desirable range for each response.}

\item{\code{high}}{A numeric vector representing the upper bounds of the desirable range for each response.}

\item{\code{target}}{A numeric vector or character string indicating the target values or goals for each response.}

\item{\code{scale}}{A numeric vector specifying the scaling factors used in the desirability calculation.}

\item{\code{importance}}{A numeric vector indicating the importance of each response in the desirability calculation.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desirability.c-print"></a>}}
\if{latex}{\out{\hypertarget{method-desirability.c-print}{}}}
\subsection{Method \code{print()}}{
Prints the details of a \code{desirability.c} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desirability.c$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desirability.c-plot"></a>}}
\if{latex}{\out{\hypertarget{method-desirability.c-plot}{}}}
\subsection{Method \code{plot()}}{
Plots the desirability functions based on the specified parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desirability.c$plot(scale, main, xlab, ylab, line.width, col, numPoints = 500)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{A numeric vector specifying the scaling factors used in the plot.}

\item{\code{main}}{A character string specifying the main title of the plot.}

\item{\code{xlab}}{A character string specifying the label for the x-axis.}

\item{\code{ylab}}{A character string specifying the label for the y-axis.}

\item{\code{line.width}}{A numeric value specifying the width of the plot lines.}

\item{\code{col}}{A vector of colors for the plot lines.}

\item{\code{numPoints}}{An integer specifying the number of points to plot (default is 500).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-desirability.c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-desirability.c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{desirability.c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
