% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.2_Distr_DistrCollection_Classes.R
\name{DistrCollection}
\alias{DistrCollection}
\title{DistrCollection-class: Class `DistrCollection`}
\description{
R6 Class for Managing a Collection of Distribution Objects
}
\examples{
set.seed(123)
data1 <- rnorm(100, mean = 5, sd = 2)
parameters1 <- list(mean = 5, sd = 2)
distr1 <- Distr$new(x = data1, name = "normal",
                    parameters = parameters1, sd = 2,
                    n = 100, loglik = -120)

data2 <- rpois(100, lambda = 3)
parameters2 <- list(lambda = 3)
distr2 <- Distr$new(x = data2, name = "poisson",
                    parameters = parameters2, sd = sqrt(3),
                    n = 100, loglik = -150)
collection <- DistrCollection$new()
collection$add(distr1)
collection$add(distr2)
collection$summary()
collection$plot()
}
\seealso{
\code{\link{Distr}}, \code{\link{distribution}}, \code{\link{FitDistr}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{distr}}{List of \code{\link{Distr}} objects.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DistrCollection-new}{\code{DistrCollection$new()}}
\item \href{#method-DistrCollection-add}{\code{DistrCollection$add()}}
\item \href{#method-DistrCollection-get}{\code{DistrCollection$get()}}
\item \href{#method-DistrCollection-print}{\code{DistrCollection$print()}}
\item \href{#method-DistrCollection-summary}{\code{DistrCollection$summary()}}
\item \href{#method-DistrCollection-plot}{\code{DistrCollection$plot()}}
\item \href{#method-DistrCollection-clone}{\code{DistrCollection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-new}{}}}
\subsection{Method \code{new()}}{
Initialize the fields of the \code{DistrCollection} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-add"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-add}{}}}
\subsection{Method \code{add()}}{
Add a \code{Distr} object to the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$add(distr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distr}}{A \code{Distr} object to add to the collection.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-get"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-get}{}}}
\subsection{Method \code{get()}}{
Get a \code{Distr} object from the collection by its index.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$get(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Integer index of the \code{Distr} object to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Distr} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-print"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-print}{}}}
\subsection{Method \code{print()}}{
Print the summary of all distributions in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-summary"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the goodness of fit for all distributions in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame with distribution names, Anderson-Darling test statistics, and p-values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-plot"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-plot}{}}}
\subsection{Method \code{plot()}}{
Plot all distributions in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$plot(
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  line.col = "red",
  fill.col = "lightblue",
  border.col = "black",
  line.width = 1,
  box = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xlab}}{Character string for the x-axis label.}

\item{\code{ylab}}{Character string for the y-axis label.}

\item{\code{xlim}}{Numeric vector specifying the x-axis limits.}

\item{\code{ylim}}{Numeric vector specifying the y-axis limits.}

\item{\code{line.col}}{Character string for the color of the plot line. Default is "red".}

\item{\code{fill.col}}{Character string for the color of the histogram fill. Default is "lightblue".}

\item{\code{border.col}}{Character string for the color of the histogram border. Default is "black".}

\item{\code{line.width}}{Numeric value specifying the width of the plot line. Default is 1.}

\item{\code{box}}{Logical value indicating whether to draw a box with the parameters in the plot. Default is TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DistrCollection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DistrCollection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistrCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
