% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_fxns.R
\name{save_png}
\alias{save_png}
\title{Open png device and return info on the file being created}
\usage{
save_png(
  plotinfo,
  file,
  plotdir,
  pwidth,
  pheight,
  punits,
  res,
  ptsize,
  caption = NA,
  alt_text = NA,
  filenameprefix = NA
)
}
\arguments{
\item{plotinfo}{table of information about all plots}

\item{file}{filename to write to (including .png extension)}

\item{plotdir}{directory where plots will be written}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. The default is \code{pwidth=6.5}.}

\item{pheight}{Height of plots printed to png files in units of \code{punits}.
Default is designed to allow two plots per page, with \code{pheight_tall} used
for plots that work best with a taller format and a single plot per page.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" (centimeters), or "mm" (millimeters).
The default is \code{punits="in"}.}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{Point size for plotted text in plots printed to files (see
\code{help("png")} in R for details).}

\item{caption}{caption for the image}

\item{alt_text}{alternative text for screen readers
(if left as NA then will be set based on the caption)}

\item{filenameprefix}{Additional text to append to PNG or PDF file names.
It will be separated from default name by an underscore.}
}
\description{
this was previously contained within each of the SSplotXXX() functions.
It (1) translates the not-quite-matching specifications for the image to the
values needed by png(), then (2) returns the plotinfo data.frame
(which exists within each function which calls this) after adding a row
with the filename and caption for each new plot
Note: this just opens the png device which needs to be closed via dev.off()
outside this function.
}
\author{
Ian G. Taylor
}
