% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotSpawnrecruit.R
\name{SSplotSpawnrecruit}
\alias{SSplotSpawnrecruit}
\title{Plot spawner-recruit curve.}
\usage{
SSplotSpawnrecruit(
  replist,
  subplot = 1:3,
  add = FALSE,
  plot = TRUE,
  print = FALSE,
  xlim = NULL,
  ylim = NULL,
  labels = c("Spawning biomass (mt)", "Recruitment (1,000s)", "Spawning output",
    expression(paste("Spawning output (relative to ", italic(B)[0], ")")),
    expression(paste("Recruitment (relative to  ", italic(R)[0], ")")),
    "Log recruitment deviation"),
  bioscale = "default",
  plotdir = "default",
  pwidth = 6.5,
  pheight = 6.5,
  punits = "in",
  res = 300,
  ptsize = 10,
  verbose = TRUE,
  colvec = c("blue", "black", "black", gray(0, 0.7)),
  ltyvec = c(1, 2, 1, NA),
  ptcol = "default",
  legend = TRUE,
  legendloc = NULL,
  minyr = "default",
  textmindev = 0.5,
  relative = FALSE,
  expected = TRUE,
  estimated = TRUE,
  bias_adjusted = TRUE,
  show_env = TRUE,
  virg = TRUE,
  init = TRUE,
  forecast = FALSE
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{subplot}{vector of which subplots to show.  1=plot without labels,
2=plot with year labels.}

\item{add}{add to existing plot?}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{xlim}{optional control of x range}

\item{ylim}{optional control of y range}

\item{labels}{vector containing x-axis label for models with spawning biomass
in metric tons, y-axis label, and alternative x-axis for models with a fecundity
relationship making spawning output not equal to spawning biomass.}

\item{bioscale}{multiplier on spawning biomass, set to 0.5 for single-sex
models}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. The default is \code{pwidth=6.5}.}

\item{pheight}{Height of plots printed to png files in units of \code{punits}.
Default is designed to allow two plots per page, with \code{pheight_tall} used
for plots that work best with a taller format and a single plot per page.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" (centimeters), or "mm" (millimeters).
The default is \code{punits="in"}.}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{Point size for plotted text in plots printed to files (see
\code{help("png")} in R for details).}

\item{verbose}{report progress to R GUI?}

\item{colvec}{vector of length 4 with colors for 3 lines and 1 set of points
(where the 4th value for the points is the color of the circle around the
background color provided by \code{ptcol}}

\item{ltyvec}{vector of length 4 with line types for the 3 lines and 1 set
of points, where the points are disconnected (lty=NA) by default}

\item{ptcol}{vector or single value for the color of the points, "default"
will by replaced by a vector of colors of length equal to
\code{nrow(replist[["recruit"]])}}

\item{legend}{add a legend to the figure?}

\item{legendloc}{location of legend. By default it is chosen as the first
value in the set of "topleft", "topright", "bottomright" that results in no
overlap with the points in the plot, but the user can override this with their
choice of location. See ?legend for more info on the options.}

\item{minyr}{minimum year of recruitment deviation to show in plot}

\item{textmindev}{minimum recruitment deviation for label to be added so
only extreme devs are labeled (labels are added to first and last years as
well).  Default=0.7.}

\item{relative}{scale both axes so that B0 and R0 are at 1
to show spawning output and recruitment relative to the equilibrium}

\item{expected}{show line for expected recruitment (stock-recruit curve)}

\item{estimated}{show points for estimated recruitment values
(including deviations)}

\item{bias_adjusted}{show lines for bias adjusted expected recruitment}

\item{show_env}{add line for expected recruitment with environmental
variability}

\item{virg}{add point for equilibrium conditions (x=B0,y=R0)}

\item{init}{add point for initial conditions (x=B1,y=R1), only appears
if this point differs from virgin values}

\item{forecast}{include forecast years in the curve?}
}
\description{
Plot spawner-recruit curve based on output from Stock Synthesis model.
}
\seealso{
\code{\link[=SS_plots]{SS_plots()}}, \code{\link[=SS_output]{SS_output()}}
}
\author{
Ian Stewart, Ian Taylor
}
