% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotAgeMatrix.R
\name{SSplotAgeMatrix}
\alias{SSplotAgeMatrix}
\title{Plot matrix of either length or observed age at true age}
\usage{
SSplotAgeMatrix(
  replist,
  option = 1,
  slices = NULL,
  scale = NULL,
  add = FALSE,
  col.grid = "grey90",
  col.bars = grey(0, alpha = 0.5),
  shift_hi = 0,
  shift_lo = 0,
  plot = TRUE,
  print = FALSE,
  labels = c("Age", "Length", "True age", "Observed age", "for ageing error type",
    "Distribution of", "at"),
  pwidth = 6.5,
  pheight = 5,
  punits = "in",
  res = 300,
  ptsize = 10,
  cex.main = 1,
  mainTitle = TRUE,
  plotdir = "default"
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{option}{Switch set to either 1 for length at true age or
2 for obs. age at true age}

\item{slices}{Optional input to choose which matrix (slice of the 3D-array)
within $AAK or $ALK to plot. By default all slices will be shown.
For ageing imprecision this should correspond to the ageing error matrix
number. Distribution of length at age ($ALK) is ordered by season,
sub-season, and then morph. A future version could allow subsetting plots
by these dimensions.}

\item{scale}{Multiplier for bars showing distribution. Species with many ages
benefit from expanded bars. NULL value causes function to attempt automatic
scaling.}

\item{add}{Add to existing plot}

\item{col.grid}{A character value specifying the color of the grid lines}

\item{col.bars}{The color of the filled polygons.}

\item{shift_hi}{A numeric value specifying the amount to shift the top of
the polygon up.}

\item{shift_lo}{A numeric value specifying the amount to shift the bottom
of the polygon up.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{labels}{Vector of labels for plots (titles and axis labels)}

\item{pwidth}{Width of plot}

\item{pheight}{Height of plot}

\item{punits}{Units for PNG file}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{Point size for PNG file}

\item{cex.main}{Character expansion for plot titles}

\item{mainTitle}{Logical indicating if a title should be included at the top}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}
}
\description{
Distribution of length at age or observed age at true age is represented
as a histogram. Values are from the AGE_LENGTH_KEY and AGE_AGE_KEY sections
of Report.sso ($ALK and $AAK in the list created by SS_output)
}
\seealso{
\code{\link[=SSplotNumbers]{SSplotNumbers()}}
}
\author{
Ian G. Taylor
}
