% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_writedat.R
\name{SS_writedat}
\alias{SS_writedat}
\title{write Stock Synthesis data file}
\usage{
SS_writedat(
  datlist,
  outfile,
  version = "3.30",
  overwrite = FALSE,
  faster = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{datlist}{List object created by \code{\link[=SS_readdat]{SS_readdat()}}
(or by \code{\link[=SS_readdat_3.24]{SS_readdat_3.24()}} or \code{\link[=SS_readdat_3.24]{SS_readdat_3.24()}})}

\item{outfile}{Filename for where to write new data file.}

\item{version}{SS version number. Currently only "3.24" or "3.30" are supported,
either as character or numeric values (noting that numeric 3.30 = 3.3).}

\item{overwrite}{Should existing files be overwritten? Default=FALSE.}

\item{faster}{Speed up writing by writing length and age comps without aligning
the columns (by using write.table instead of print.data.frame)}

\item{verbose}{Should there be verbose output while running the file?}
}
\description{
Write Stock Synthesis data file from list object in R which was probably
created using \code{\link[=SS_readdat]{SS_readdat()}}. This function is a
wrapper which calls either SS_writedat_3.24 or SS_writedat_3.30
(and potentially additional functions in the future). This setup allows those
functions to be cleaner (if somewhat redundant) than a single function that
attempts to do everything.
}
\seealso{
\code{\link[=SS_writedat_3.24]{SS_writedat_3.24()}}, \code{\link[=SS_writedat_3.30]{SS_writedat_3.30()}},
\code{\link[=SS_readdat]{SS_readdat()}},
\code{\link[=SS_readstarter]{SS_readstarter()}}, \code{\link[=SS_writestarter]{SS_writestarter()}},
\code{\link[=SS_readforecast]{SS_readforecast()}}, \code{\link[=SS_writeforecast]{SS_writeforecast()}}
}
\author{
Ian G. Taylor, Yukio Takeuchi, Gwladys I. Lambert
}
