% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_emission_intensity.R
\name{prep_emission_intensity}
\alias{prep_emission_intensity}
\title{Prepare data for a emission intensity plot}
\usage{
prep_emission_intensity(data, convert_label = identity, span_5yr = FALSE)
}
\arguments{
\item{data}{A data frame. Requirements:
\itemize{
\item The structure must be like \link{sda_demo}.
\item The column \code{sector} must have a single value (e.g. "cement").
\item (Optional) If present, the column \code{label} is used for data labels.
}}

\item{convert_label}{A symbol. The unquoted name of a function to apply to y-axis labels. For example:
\itemize{
\item To convert labels to uppercase use \code{convert_label = toupper}.
\item To get the default behavior of \code{qplot_emission_intensity} use \code{convert_label = to_title}.
}}

\item{span_5yr}{Logical. Use \code{TRUE} to restrict the time span to 5 years from
the start year (the default behavior of \code{qplot_emission_intensity()}), or use
\code{FALSE} to impose no restriction.}
}
\value{
A data-frame ready to be plotted using \code{plot_emission_intensity()}.
}
\description{
Prepare data for a emission intensity plot
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(sda_demo, sector == "cement" & region == "global")
prep_emission_intensity(data)
}
\seealso{
\link{sda_demo}.
}
