% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_diff.R
\name{set_diff}
\alias{set_diff}
\title{Set Differences}
\usage{
set_diff(x, y)
}
\arguments{
\item{x, y}{vectors (of the same mode)}
}
\value{
a qwraps2_set_diff object, a list of set comparisons

\itemize{
  \item \code{all_values} = \code{\link[base]{union}(x, y)}
  \item \code{x_only}     = \code{\link[base]{setdiff}(x, y)}
  \item \code{y_only}     = \code{\link[base]{setdiff}(y, x)}
  \item \code{both}       = \code{\link[base]{intersect}(x, y)}
  \item \code{equal}      = \code{\link[base]{setequal}(x, y)}
}
}
\description{
Function for testing for unique values between two vectors, specifically,
which values are in vector1, and not in vector2, which values are not in
vector1 and in vector2, which values are in both vector1 and vector2.
}
\examples{

# example with two sets which as a union are the upper and lower case vowels.
set_a <- c("A", "a", "E",      "I", "i", "O", "o", "U", "u", "E", "I")
set_b <- c("A", "a", "E", "e",      "i",      "o", "U", "u", "u", "a", "e")

set_diff(set_a, set_b)
str(set_diff(set_a, set_b))

set_diff(set_b, set_a)

# example
set_a <- 1:90
set_b <- set_a[-c(23, 48)]
set_diff(set_a, set_b)
set_diff(set_b, set_a)

# example
set_a <- c("A", "A", "B")
set_b <- c("B", "A")
set_diff(set_a, set_b)

}
