% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{spectral}
\alias{spectral}
\title{Spectral Decomposition of a Hermitian Matrix}
\usage{
spectral(S, multiplicity = TRUE, tol = .Machine$double.eps^0.5, ...)
}
\arguments{
\item{S}{a Hermitian matrix. \emph{Obs}: The matrix is always assumed to be Hermitian,
and only its lower triangle (diagonal included) is used.}

\item{multiplicity}{if \code{TRUE} (default), tries to infer eigenvalue multiplicity. If set to
\code{FALSE}, each eigenvalue is considered unique with multiplicity one.}

\item{tol}{two eigenvalues \code{x}, \code{y} are considered equal if \code{abs(x-y) < tol}. Defaults to
\code{tol=.Machine$double.eps^0.5}.}

\item{...}{further arguments passed on to \code{\link[base:eigen]{base::eigen()}}}
}
\value{
The spectral decomposition of \code{S} is returned as a list with components
\item{eigvals}{vector containing the unique eigenvalues of \code{S} in \emph{decreasing} order.}
\item{multiplicity}{multiplicities of the eigenvalues in \code{eigvals}.}
\item{eigvectors}{a \verb{nrow(S) x nrow(S)} unitary matrix whose columns are eigenvectors ordered
according to \code{eigvals}. Note that there may be more eigenvectors than eigenvalues if
\code{multiplicity=TRUE}, however eigenvectors of the same eigenspace are next to each other.}

The Spectral Theorem ensures the eigenvalues of \code{S} are real and that the vector space
admits an orthonormal basis consisting of eigenvectors of \code{S}. Thus, if \code{s <- spectral(S)},
and \verb{V <- s$eigvectors; lam <- s$eigvals}, then

\deqn{S = V \Lambda V^{*}}

where \eqn{\Lambda =\ }\code{diag(rep(lam, times=s$multiplicity))}
}
\description{
\code{spectral()} is a wrapper around \code{\link[base:eigen]{base::eigen()}} designed for Hermitian matrices,
which can handle repeated eigenvalues.
}
\examples{
spectral(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3))

# Use "tol" to set the tolerance for numerical equality
spectral(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3), tol=10e-5)

# Use "multiplicity=FALSE" to force each eigenvalue to be considered unique
spectral(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3), multiplicity = FALSE)

}
\seealso{
\code{\link[base:eigen]{base::eigen()}}, \code{\link[=get_eigspace.spectral]{get_eigspace.spectral()}},
\code{\link[=get_eigproj.spectral]{get_eigproj.spectral()}}, \code{\link[=get_eigschur.spectral]{get_eigschur.spectral()}},
\code{\link[=act_eigfun.spectral]{act_eigfun.spectral()}}
}
