% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctqwalk.R
\name{ctqwalk}
\alias{ctqwalk}
\title{Create a Continuous-time Quantum Walk}
\usage{
ctqwalk(hamiltonian, ...)
}
\arguments{
\item{hamiltonian}{a Hermitian Matrix representing the Hamiltonian of the system.}

\item{...}{further arguments passed on to \code{\link[=spectral]{spectral()}}}
}
\value{
A list with the walk related objects, i.e the hamiltonian and its spectral
decomposition (See \code{\link[=spectral]{spectral()}} for further details)
}
\description{
\code{ctqwalk()} creates a quantum walk object from a hamiltonian.
}
\examples{
# Creates a walk from the adjacency matrix of the graph P3.
ctqwalk(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3))


}
\seealso{
\code{\link[=spectral]{spectral()}}, \code{\link[=unitary_matrix.ctqwalk]{unitary_matrix.ctqwalk()}},
\code{\link[=mixing_matrix.ctqwalk]{mixing_matrix.ctqwalk()}}, \code{\link[=avg_matrix.ctqwalk]{avg_matrix.ctqwalk()}},
\code{\link[=gavg_matrix.ctqwalk]{gavg_matrix.ctqwalk()}}
}
