% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vl_diff.R
\name{vl_diff}
\alias{vl_diff}
\title{Create Mean Differences from Longitudinal Viral Load Data}
\usage{
vl_diff(vl_data)
}
\arguments{
\item{vl_data}{A data frame of longitudinal viral load values per individual, where rows represent patients and columns represent sequential measurements across time (e.g., years or visits).}
}
\value{
An object of class \code{"Interaction"} with the following components:
\describe{
\item{vl3_diff}{Mean differences of raw viral load values.}
}
}
\description{
This function calculates the mean differences of viral loads across time for each individual in the dataset.
}
\examples{
data(vl_3)
vl_data <- vl_3[,-1]
result <- vl_diff(vl_data)
}
