% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEffects.R
\name{calculateDifferences}
\alias{calculateDifferences}
\title{Calculate differences between conditions specified in constraints}
\usage{
calculateDifferences(x, effect = c("estimate", "observed"))
}
\arguments{
\item{x}{an object of class \code{\link{BFBayesFactorConstraint-class}}.}

\item{effect}{the effect differences to be calculated. \code{effect = "estimate"}
computes the effect differences from the model estimates;
\code{effect = "observed"} computes the observed effect differences.}
}
\value{
\code{calculateDifferences} returns an object of class
  \code{\link[tibble]{tbl_df}}, with columns for ID, type of effect,
  specified constraint, and estimates.
}
\description{
Calculates the differences between the conditions specified in the constraints
  of a \code{BFBayesFactorConstraint} object for each individual.
}
\examples{
\dontrun{
data(stroop)

resStroop <- constraintBF(rtS ~ ID*cond,
                          data = stroop,
                          whichRandom = "ID",
                          ID = "ID",
                          whichConstraint = c(cond = "2 > 1"),
                          rscaleEffects = c("ID" = 1, "cond" = 1/6, "ID:cond" = 1/10))

calculateDifferences(resStroop, effect = "estimate")
calculateDifferences(resStroop, effect = "observed")
}

}
