% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aided_chatgpt.R
\name{learn_rate_scheduler}
\alias{learn_rate_scheduler}
\title{Learning Rate Scheduler}
\usage{
learn_rate_scheduler(initial_lr, schedule, epochs)
}
\arguments{
\item{initial_lr}{A numeric value representing the initial learning rate.}

\item{schedule}{A function that takes the epoch number as input and returns the adjusted learning rate.}

\item{epochs}{An integer specifying the total number of epochs.}
}
\value{
A numeric vector representing the learning rate for each epoch.
}
\description{
This function adjusts the learning rate at each epoch according to a custom schedule.
}
\examples{
schedule <- function(epoch) { 0.01 * (0.9 ^ epoch) }
learn_rate_scheduler(0.01, schedule, epochs = 10)

}
