% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{score}
\alias{score}
\title{Observed Unweighted Scoring of a Set of Variables/Items}
\usage{
score(
  data,
  vrb.nm,
  avg = TRUE,
  ov.min = 1,
  prop = TRUE,
  inclusive = TRUE,
  impute = TRUE,
  std = FALSE,
  std.data = std,
  std.score = std
)
}
\arguments{
\item{data}{data.frame or numeric/logical matrix}

\item{vrb.nm}{character vector of colnames in \code{data} specifying the set
of variables/items.}

\item{avg}{logical vector of length 1 specifying whether mean scores (TRUE)
or sum scores (FALSE) should be created.}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{length(vrb.nm)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the score
should be calculated (rather than NA) if the frequency of observed values
in a row is exactly equal to \code{ov.min}.}

\item{impute}{logical vector of length 1 specifying if missing values should
be imputed with the mean of observed values from each row of
\code{data[vrb.nm]} (i.e., row mean imputation). If TRUE (default), this
will make sums over the same rows with different frequencies of missing
values comparable. Note, this argument is only used when \code{avg} = FALSE
since when \code{avg} = TRUE row mean imputation is always done implicitly.}

\item{std}{logical vector of length 1 specifying whether 1)
\code{data[vrb.nm]} should be standardized before scoring and 2) the score
standardized after creation. This argument is for convenience as these two
standardization processes are often used together. However, this argument
will be overwritten by any non-default value for \code{std.data} and
\code{std.score}.}

\item{std.data}{logical vector of length 1 specifying whether
\code{data[vrb.nm]} should be standardized before scoring.}

\item{std.score}{logical vector of length 1 specifying whether the score
should be standardized after creation.}
}
\value{
numeric vector of the mean/sum of each row or \code{NA} if the
  frequency of observed values is less than (or equal to) \code{ov.min}. The
  names are the rownames of \code{data}.
}
\description{
\code{score} calculates observed unweighted scores across a set of variables/items.
If a row's frequency of observed data is less than (or equal to)
\code{ov.min}, then NA is returned for that row. \code{data[vrb.nm]} is
coerced to a matrix before scoring. If the coercion leads to a character
matrix, an error is returned.
}
\examples{
score(data = attitude, vrb.nm = c("complaints","privileges","learning","raises"))
score(data = attitude, vrb.nm = c("complaints","privileges","learning","raises"),
   std = TRUE) # standardized scoring
score(data = airquality, vrb.nm = c("Ozone","Solar.R","Temp"),
   ov.min = 0.75) # conditional on observed values
}
\seealso{
\code{\link{scores}}
   \code{\link{rowMeans_if}}
   \code{\link{rowSums_if}}
   \code{\link[psych]{scoreItems}}
}
