% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagEstimator.R
\docType{class}
\name{LagEstimator-class}
\alias{LagEstimator-class}
\alias{LagEstimator}
\title{Class for a lag-window type estimator.}
\description{
For a given time series Y a lag-window estimator of the Form
\deqn{\hat{f}(\omega) = \sum_{|k|< n-1 } K_n(k) \Gamma(Y_0,Y_k) \exp(-i \omega k)} 
will be calculated on initalization. The \code{LagKernelWeight} K_n is determined
by the slot \code{weight} and the \code{LagOperator} \eqn{\Gamma(Y_0,Y_k)} is defined 
by the slot lagOp.
}
\details{
Currently, the implementation of this class allows only for the analysis of
univariate time series.
}
\section{Slots}{

\describe{
\item{\code{Y}}{the time series where the lag estimator was applied one}

\item{\code{weight}}{a \code{\link{Weight}} object to be used as lag window}

\item{\code{lagOp}}{a \code{\link{LagOperator}} object that determines which
kind of bivariate structure should be calculated.}

\item{\code{env}}{An environment to allow for slots which need to be
accessable in a call-by-reference manner:
\describe{
  \item{\code{sdNaive}}{An array used for storage of the naively
      estimated standard deviations of the smoothed periodogram.}
  \item{\code{sdNaive.done}}{a flag indicating whether \code{sdNaive}
      has been set yet.}}}
}}

\keyword{S4-classes}
