% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areadensnoisecompare2D.R
\name{areadensnoisecompare2D}
\alias{areadensnoisecompare2D}
\title{Shows areadens2D plus background noise as segmented line}
\usage{
areadensnoisecompare2D(object, spot = NULL, plot = TRUE, returndf = TRUE,
  ptype = "o", ...)
}
\arguments{
\item{object}{S3 object of working TLC}

\item{spot}{Number of the spot (counted left to right).}

\item{plot}{Boolean, TRUE default and displays densitometric distribution.}

\item{returndf}{Boolean, TRUE by default, returns \code{data.frame} with \code{x} and \code{Area} values.}

\item{ptype}{Point type for the plot. Default "o" (Uses same values as \code{type} variable from \code{plot} function)}

\item{...}{Additional parameters (for \code{plot} type function).}
}
\value{
Returns \code{data.frame} with \code{x} and \code{Area} values.
}
\description{
Plots area-denses of the spot and background.
}
\examples{
\dontrun{
#see areadens2D first
areadensnoisecompare2D(object, spot=3, ptype="l")
}

}
\author{
Ivan D. Pavicevic, \email{ivanp84@gmail.com}
}

