% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqgate.R
\name{noise}
\alias{noise}
\title{A noise gate}
\usage{
noise(bit, p = 1, error = "any", type = "ERR", args = list())
}
\arguments{
\item{bit}{integer or integer array. The bit to which to apply the gate. If
an array is provided, the gate will be applied randomly to one of the bits
only.}

\item{p}{probability with which noise is applied}

\item{error}{one of "X", "Y", "Z", "small" or "any". The model which the noise
follows. Can be one of the Pauli matrices (X,Y,Z), a random SU(2)-matrix
with a small deviation \code{sigma} from the identity ("small") or an
arbitrary, uniformly sampled, SU(2)-matrix ("any").}

\item{type}{a character vector representing the type of gate}

\item{args}{a list of further arguments passed to specific error models. For
\code{error="small"} the standard deviation \code{sigma} has to be provided
here (default=1).}
}
\value{
An S4 class 'sqgate' object is returned
}
\description{
A noise gate
}
\examples{
x <- noise(1, error="X") * qstate(nbits=2)
x
y <- noise(2, p=0.5) * x
y
z <- noise(2, error="small", args=list(sigma=0.1)) * x
z

}
