% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prices.R
\name{get_prices}
\alias{get_prices}
\title{Grab daily prices and price returns for the previous two years.}
\usage{
get_prices(companies = qmj::companies_r3k16)
}
\arguments{
\item{companies}{A data frame of company names and tickers.}
}
\value{
A matrix-like object containing relevant price data. The rows
of the matrix are dates in the international standard of YYYY-MM-DD. Each
column specifies what data it covers in the form of TICKER.DATA, with the
exception of price returns, which are stored as pret.#, where # refers to
the the i-th company given. 

The first company calculated is always the S&P 500, and its price return
column is simply 'pret'.
}
\description{
\code{get_prices} grabs price-related data for a given data frame
of companies and returns a matrix-like object containing relevant
price data.
}
\details{
\code{get_prices} is also able to write .RData files
to the user's temporary directory. If canceled partway through,
the function is able to find and re-read this data to resume progress.
Once complete, the function deletes all used temporary data.

Parameter defaults to provided data set of companies if empty.
}
\section{Functions}{
\itemize{
\item \code{get_prices()}: Calculates price returns for an xts object.

}}
\examples{
get_prices(companies_r3k16[companies_r3k16$ticker \%in\% c("AAPL", "AMZN"), ])

}
\seealso{
\code{\link{get_info}}

\code{\link{clean_downloads}}

\code{\link{tidy_prices}}
}
