% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.2.R
\name{qser2qacf}
\alias{qser2qacf}
\title{ACF of Quantile Series (QSER) or Quantile-Crossing Series (QCACF)}
\usage{
qser2qacf(y.qser)
}
\arguments{
\item{y.qser}{matrix or array of quantile-crossing series}
}
\value{
A matrix or array of ACF
}
\description{
This function creates the ACF of quantile series or quantile-crossing series
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.qser <- qcser(y,tau)
y.qacf <- qser2qacf(y.qser)
dim(y.qacf)
}
