#' Example data used in Furr & Heuckeroth, on Impression Motivation (IM)
#'
#' Self-report data from 90 participants, responding to the IM scale and
#' 12 criterion variables.
#'
#' @docType data
#'
#' @usage data(motdat)
#'
#' @format A data frame of 90 rows and 13 variables:
#'  \describe{
#'    \item{imscale}{Impression Motivation}
#'    \item{dep}{Dependence}
#'    \item{mach}{Machiavellianism}
#'    \item{dis}{Distrust}
#'    \item{res}{Resourcefulness}
#'    \item{se}{Self-efficacy}
#'    \item{ext}{Extraversion}
#'    \item{agr}{Agreeableness}
#'    \item{comp}{Complexity}
#'    \item{psc}{Public self-consciousness}
#'    \item{sm}{Self-monitoring}
#'    \item{anx}{Anxiety}
#'    \item{nfb}{Need to belong}
#'    }
#'
#' @keywords datasets
#'
#' @examples
#' data(motdat)
"motdat"
