% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcrlscR.R
\name{qc.rlsc.wrap}
\alias{qc.rlsc.wrap}
\title{Wrapper function for QC-RLSC}
\usage{
qc.rlsc.wrap(
  dat,
  cls.qc,
  cls.bl,
  method = c("subtract", "divide"),
  intra = FALSE,
  opti = TRUE,
  log10 = TRUE,
  outl = TRUE,
  shift = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame with samples (row) and variables (column).}

\item{cls.qc}{A vector with string of "qc" and "sample".}

\item{cls.bl}{A vector with string of batch indicators.}

\item{method}{Data scaling method. Support "subtract" and "divide"}

\item{intra}{A logical value indicating whether signal correction is
performed inside each batch ("intra-batch") or not ("inter-batch").}

\item{opti}{A logical value indicating whether or not 'span' parameters
are optimised.}

\item{log10}{A logical value indicating whether log10 transformation for
the data set or not. If the transformation is applied, the reverse
procedure will be performed.}

\item{outl}{A logical value indicating whether or not QC outlier
detection is employed. If TRUE, the QC outlier will be assigned as the
median of QC.}

\item{shift}{A logical value indicating whether or not batch shift is
applied after signal correction.}

\item{...}{Other parameter for 'loess'.}
}
\value{
A corrected data frame.
}
\description{
Wrapper function for QC-RLSC
}
\examples{
names(man_qc)
data <- man_qc$data
meta <- man_qc$meta

cls.qc <- factor(meta$sample_type)
cls.bl <- factor(meta$batch)

## apply  QC-RLSC wrapper function
method <- "divide"     # "subtract"
intra <- TRUE
opti <- TRUE
log10 <- TRUE
outl <- TRUE
shift <- TRUE

\donttest{
res <- qc.rlsc.wrap(data, cls.qc, cls.bl, method, intra, opti, log10,
                    outl, shift)
}
}
\seealso{
Other QC-RLSC function: 
\code{\link{qc.rlsc}()}
}
\concept{QC-RLSC function}
