% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/families.R, R/html_tables.R, R/utils.R
\name{extract_family_name}
\alias{extract_family_name}
\title{Extract Family Name from INLA Family Specification}
\usage{
extract_family_name(inla_family)

extract_family_name(inla_family)

extract_family_name(inla_family)
}
\arguments{
\item{inla_family}{INLA family specification (string or list).}
}
\value{
Character string containing the family name.

Character string with family name.
}
\description{
Extracts the family name from an INLA family specification, handling both
character strings and lists (e.g., for quantile regression).

Helper function to extract family name handling both strings and lists.
}
\examples{
\dontrun{
# Character family
extract_family_name("gaussian")  # "gaussian"

# List family (from quantile regression)
ald_spec <- convert_family_to_inla(asymmetric_laplace(), quantile = 0.9)
extract_family_name(ald_spec)    # "asymmetric_laplace"
}

}
\keyword{internal}
