% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TurgorLossPoint.R
\name{TurgorLossPoint}
\alias{TurgorLossPoint}
\title{Turgor Loss Point}
\usage{
TurgorLossPoint(
  data,
  sample = "sample",
  water.potential = "water.potential",
  RWD = "RWD",
  graph = TRUE,
  show.legend = TRUE
)
}
\arguments{
\item{data}{data frame containing columns of equal lengths giving at least the numerical
coordinates of the curve: water potential (MPa) and RWD (\%), ordered by sample by descending water potential. A
column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample ID, default: "sample"}

\item{water.potential}{optional name of the column in data containing the numeric water potential values (MPa), default: "water.potential"}

\item{RWD}{optional name of the column in data containing numeric relative water deficit values (\%), default: "RWD"}

\item{graph}{set FALSE if no plots are to be returned}

\item{show.legend}{set FALSE if no legend is to be shown in the plots}
}
\value{
List splitted by sample consisting of
\item{turgor.loss.point}{coordinates of the turgor loss point (RWD)}
\item{formula}{formula of the exponential and linear part of the combined fits}
\item{coef}{coefficients of combined model}
\item{conf_int}{upper (97.5 \%) and lower (2.5 \%) border of 95 \% confidence interval of model parameters}
If graph = TRUE, the plotted original data is displayed with the exponential and
linear fit of the combined model as well as the x-coordinate (RWD) of the turgor loss point.
}
\description{
Determines the x coordinate (RWD) of the turgor loss point in a set of experimentally obtained
pressure volume curves.
}
\details{
Before using this function, check the data for an initial plateau. Data points in the initial part of the water potential
versus RWD plot with a stronger then expected decline need to be omitted. \cr \cr
The data is fitted using the Gauss-Newton algorithm of nls() to a combined exponential and linear
model. The exponential and linear parts are extracted and RWD at turgor loss point is localized at their point of minimum distance.
}
\examples{
# get sample data
data <- RelativeWaterDeficit(pressure_volume_data)[pressure_volume_data$sample == 10, ]

# identify turgor loss point in curve
turgor_loss_point <- TurgorLossPoint(data)

}
