% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pid_thr.R
\name{pid.grt}
\alias{pid.grt}
\title{Identification of panel SVEC models by imposing long- and short-run restrictions}
\usage{
pid.grt(
  x,
  LR = NULL,
  SR = NULL,
  start = NULL,
  max.iter = 100,
  conv.crit = 1e-07,
  maxls = 1
)
}
\arguments{
\item{x}{An object of class '\code{pvarx}' or a list of VECM objects 
that will be \link[=as.varx]{coerced} to '\code{varx}'. 
Panel of VAR objects estimated under rank-restriction.}

\item{LR}{Matrix. The restricted long-run impact matrix.}

\item{SR}{Matrix. The restricted contemporaneous impact matrix.}

\item{start}{Vector. The starting values for \eqn{\gamma}, 
set by \code{\link[stats]{rnorm}} if \code{NULL} (the default).}

\item{max.iter}{Integer. The maximum number of iterations.}

\item{conv.crit}{Real number. Convergence value of algorithm.}

\item{maxls}{Real number. Maximum movement of the parameters between two iterations of the scoring algorithm.}
}
\value{
List of class '\code{pid}' with elements:
\item{A}{Matrix. The lined-up coefficient matrices \eqn{A_j, j=1,\ldots,p} 
   or the lagged variables in the panel VAR.}
\item{B}{Matrix. Mean group of the estimated structural impact matrices \eqn{B_i}, 
   i.e. the unique decomposition of the covariance matrices of reduced-form errors.}
\item{L.varx}{List of '\code{varx}' objects for the individual estimation results
  to which the structural impact matrices \eqn{B_i} have been added.}
\item{args_pid}{List of characters and integers indicating the identification methods and specifications that have been used.}
\item{args_pvarx}{List of characters and integers indicating the estimator and specifications that have been used.}
}
\description{
Identifies a panel of SVEC models by utilizing a scoring algorithm 
  to impose long- and short-run restrictions. 
  See the details of \code{\link[vars]{SVEC}} in \strong{vars}.
}
\examples{
data("PCAP")
names_k = c("g", "k", "l", "y")  # variable names
names_i = levels(PCAP$id_i)      # country names
names_s = NULL                   # optional shock names
L.data  = sapply(names_i, FUN=function(i) 
  ts(PCAP[PCAP$id_i==i, names_k], start=1960, end=2019, frequency=1), 
  simplify=FALSE)

# colnames of the restriction matrices are passed as shock names #
SR = matrix(NA, nrow=4, ncol=4, dimnames=list(names_k, names_s))
SR[1, 2] = 0
SR[3, 4] = 0
LR = matrix(NA, nrow=4, ncol=4, dimnames=list(names_k, names_s))
LR[ , 3:4] = 0

# estimate and identify panel SVECM #
R.pvec = pvarx.VEC(L.data, lags=2, dim_r=2, type="Case4")
R.pid  = pid.grt(R.pvec, LR=LR, SR=SR)

}
\references{
Amisano, G. and Giannini, C. (1997): 
  \emph{Topics in Structural VAR Econometrics}, 
  Springer, 2nd ed.

Breitung, J., Brueggemann R., and Luetkepohl, H. (2004): 
  "Structural Vector Autoregressive Modeling and Impulse Responses", 
  in \emph{Applied Time Series Econometrics}, 
  ed. by H. Luetkepohl and M. Kraetzig, 
  Cambridge University Press, Cambridge.

Johansen, S. (1996): 
  \emph{Likelihood-Based Inference in Cointegrated Vector Autoregressive Models}, 
  Advanced Texts in Econometrics, Oxford University Press, USA.

Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.

Pfaff, B. (2008):
  "VAR, SVAR and SVEC Models: Implementation within R Package \strong{vars}",
  \emph{Journal of Statistical Software}, 27, pp. 1-32.
}
\seealso{
\ldots the original \code{\link[vars]{SVEC}} by Pfaff (2008) in \strong{vars}. 
  Note that \code{\link{pid.grt}}  relies on this underlying procedure, 
  but allows for the additional model specifications in \code{\link{pvarx.VEC}} 
  and for the bootstrap procedures in \code{\link{sboot.pmb}}, 
  both provided by the \strong{pvars} package.

Other panel identification functions: 
\code{\link{pid.chol}()},
\code{\link{pid.cvm}()},
\code{\link{pid.dc}()},
\code{\link{pid.iv}()}
}
\concept{panel identification functions}
