% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coint.R
\name{coint}
\alias{coint}
\alias{coint.JO}
\alias{coint.SL}
\title{Test procedures for the cointegration rank}
\usage{
coint.JO(
  y,
  dim_p,
  x = NULL,
  dim_q = dim_p,
  type = c("Case1", "Case2", "Case3", "Case4", "Case5"),
  t_D1 = NULL,
  t_D2 = NULL
)

coint.SL(y, dim_p, type_SL = c("SL_mean", "SL_trend"), t_D = NULL)
}
\arguments{
\item{y}{Matrix. A \eqn{(K \times (p+T))} data matrix of the \eqn{K} endogenous time series variables.}

\item{dim_p}{Integer. Lag-order \eqn{p} for the endogenous variables \code{y}.}

\item{x}{Matrix. A \eqn{(L \times (q+T))} data matrix of the \eqn{L} weakly exogenous time series variables.}

\item{dim_q}{Integer. Lag-order \eqn{q} for the weakly exogenous variables \code{x}. 
The literature uses \code{dim_p} (the default).}

\item{type}{Character. The conventional case of the 
\link[=as.t_D]{deterministic term} in the Johansen procedure.}

\item{t_D1}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{1,t}}, 
which are restricted to the cointegration relations.
The accompanying lagged regressors are automatically included in \eqn{d_{2,t}}. 
The \eqn{p}-values are calculated for up to two breaks resp. three sub-samples.}

\item{t_D2}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{2,t}}, 
which are unrestricted.}

\item{type_SL}{Character. The conventional case of the 
\link[=as.t_D]{deterministic term} in the Saikkonen-Luetkepohl (SL) procedure.}

\item{t_D}{List of vectors. The activation periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{t}} of the SL-procedure. 
The accompanying lagged regressors are automatically included in \eqn{d_{t}}. 
The \eqn{p}-values are calculated for up to two breaks resp. three sub-samples.}
}
\value{
A list of class '\code{coint}', 
  which contains elements of length \eqn{K} for each \eqn{r_{H0}=0,\ldots,K-1}:
\item{r_H0}{Rank under each null hypothesis.}
\item{stats_TR}{Trace (TR) test statistics.}
\item{stats_ME}{Maximum eigenvalue (ME) test statistics.}
\item{pvals_TR}{\eqn{p}-values of the TR test.}
\item{pvals_ME}{\eqn{p}-values of the ME test. 
  \code{NA} if moments of the gamma distribution are not available 
  for the chosen data generating process.}
\item{lambda}{Eigenvalues, the squared canonical correlation coeffcients 
  (saved only for the Johansen procedure).}
\item{args_coint}{List of characters and integers 
  indicating the cointegration test and specifications that have been used.}
}
\description{
Performs test procedures for the rank of cointegration in a single VAR model.
  The \eqn{p}-values are approximated by gamma distributions, 
  whose moments are automatically adjusted to 
  potential period-specific deterministic regressors 
  and weakly exogenous regressors in the partial VECM.
}
\section{Functions}{
\itemize{
\item \code{coint.JO()}: Johansen procedure.

\item \code{coint.SL()}: (Trenkler)-Saikkonen-Luetkepohl procedure.

}}
\examples{
### reproduce basic example in "urca" ###
library("urca")
data(denmark)
sjd = denmark[ , c("LRM", "LRY", "IBO", "IDE")]

# rank test and estimation of the full VECM as in "urca" #
R.JOrank = coint.JO(y=sjd,      dim_p=2, type="Case2", t_D2=list(n.season=4))
R.JOvecm = VECM(y=sjd, dim_r=1, dim_p=2, type="Case2", t_D2=list(n.season=4))

# ... and of the partial VECM, i.e. after imposing weak exogeneity #
R.KNrank = coint.JO(y=sjd[ , c("LRM"), drop=FALSE],   dim_p=2,
                    x=sjd[ , c("LRY", "IBO", "IDE")], dim_q=2, 
                    type="Case2", t_D1=list(t_shift=36), t_D2=list(n.season=4))
R.KNvecm = VECM(y=sjd[ , c("LRM"), drop=FALSE],   dim_p=2,
                x=sjd[ , c("LRY", "IBO", "IDE")], dim_q=2, dim_r=1, 
                type="Case2", t_D1=list(t_shift=36), t_D2=list(n.season=4))

### reproduce Oersal,Arsova 2016:22, Tab.7.5 "France" ###
data("ERPT")
names_k = c("lpm5", "lfp5", "llcusd")  # variable names for "Chemicals and related products"
names_i = levels(ERPT$id_i)[c(1,6,2,5,4,3,7)]  # ordered country names
L.data  = sapply(names_i, FUN=function(i) 
   ts(ERPT[ERPT$id_i==i, names_k], start=c(1995, 1), frequency=12), 
   simplify=FALSE)
R.TSLrank = coint.SL(y=L.data$France, dim_p=3, type_SL="SL_trend", t_D=list(t_break=89))

}
\references{
Johansen, S. (1988): 
  "Statistical Analysis of Cointegration Vectors", 
  \emph{Journal of Economic Dynamics and Control}, 12, pp. 231-254.

Doornik, J. (1998): 
  "Approximations to the Asymptotic Distributions of Cointegration Tests", 
  \emph{Journal of Economic Surveys}, 12, pp. 573-93.

Johansen, S., Mosconi, R., and Nielsen, B. (2000): 
  "Cointegration Analysis in the Presence of Structural Breaks in the Deterministic Trend",
  \emph{Econometrics Journal}, 3, pp. 216-249.

Kurita, T., Nielsen, B. (2019):
  "Partial Cointegrated Vector Autoregressive Models with Structural Breaks in Deterministic Terms",
  \emph{Econometrics}, 7, pp. 1-35.

Saikkonen, P., and Luetkepohl, H. (2000):
  "Trend Adjustment Prior to Testing for the Cointegrating Rank of a Vector Autoregressive Process",
  \emph{Journal of Time Series Analysis}, 21, pp. 435-456.

Trenkler, C. (2008): 
  "Determining \eqn{p}-Values for Systems Cointegration Tests with a Prior Adjustment for Deterministic Terms", 
  \emph{Computational Statistics}, 23, pp. 19-39.

Trenkler, C., Saikkonen, P., and Luetkepohl, H. (2008): 
  "Testing for the Cointegrating Rank of a VAR Process with Level Shift and Trend Break", 
  \emph{Journal of Time Series Analysis}, 29, pp. 331-358.
}
\concept{cointegration rank tests}
