% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_pushover_app.R
\name{set_pushover_app}
\alias{set_pushover_app}
\alias{get_pushover_app}
\alias{unset_pushover_app}
\title{Set, get, and unset the Pushover application token}
\usage{
set_pushover_app(token = NULL, ask = is_interactive())

get_pushover_app(ask = is_interactive())

unset_pushover_app()
}
\arguments{
\item{token}{The application token to be used. If none is provided, a prompt
will request the token (interactive sessions only).}

\item{ask}{Whether or not to ask for the token if none is provided. Note
that this option only works in interactive sessions.}
}
\value{
\code{get_pushover_app()} returns a string containing the current
application token. If the token is not set but \code{ask} is \code{TRUE},
the user will be prompted for a token.
}
\description{
\code{set_pushover_app()} sets the Pushover application token to be used in
subsequent commands, \code{get_pushover_app()} gets the application token
that is currently set, and \code{unset_pushover_app()} unsets the token.
}
\details{
\code{set_pushover_app()} only sets the Pushover app token for the current
session. If a different value is specified in \code{.Renviron}, that value will be
used in future sessions. Similarly, \code{unset_pushover_app()} will only
unset the app token for the current session.

To receive an application token, register a new application after
logging in to your account at \url{https://pushover.net/apps}.
}
\examples{
\dontrun{
set_pushover_app(token = "azGDORePK8gMaC0QOYAMyEEuzJnyUi")
}
}
