% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{faceted_time_series_plot2}
\alias{faceted_time_series_plot2}
\title{Alternate version with wind rose at each time step + scatter plot of methane concentration time series}
\usage{
faceted_time_series_plot2(
  sensor_concentrations,
  sensor_coords,
  wind_data,
  start_time,
  end_time,
  output_dt,
  text_size = 12
)
}
\arguments{
\item{sensor_concentrations}{Data frame. Output from a sensor simulation function,
which must include a column named "Group.1" which contains the timestamps (e.g., "YYYY-MM-DD HH:MM:SS") and a column "Sensor_1"
for the sensor concentration values.}

\item{sensor_coords}{A data frame or matrix containing sensor locations.}

\item{wind_data}{A list containing wind data with components u and v}

\item{start_time}{POSIXct. Start time of the simulation.}

\item{end_time}{POSIXct. End time of the simulation.}

\item{output_dt}{Integer. Desired time resolution (in seconds) for the final output of concentrations.}

\item{text_size}{Default at 12.}
}
\value{
A ggplot object with faceted time series plots of methane concentrations and wind rose data.
}
\description{
Alternate version with wind rose at each time step + scatter plot of methane concentration time series
}
\examples{
set.seed(123)
sim_dt <- 10
puff_dt <- 10
output_dt <- 60
start_time <- "2024-01-01 12:00:00"
end_time <- "2024-01-01 13:00:00"
emission_rate <- 3.5
wind_data <- data.frame(
  wind_u = runif(3601, min = -3, max = 0.7),
  wind_v = runif(3601, min = -3, max = 1.5)
)
source_coords <- c(0, 0, 2.5)
sensor_coords <- matrix(c(-6.525403221327715e-15, -35.52264, 2.01775), ncol = 3, byrow = TRUE)

out <- simulate_sensor_mode(
  start_time, end_time, source_coords,
  emission_rate, wind_data, sensor_coords, sim_dt, puff_dt, output_dt, puff_duration = 1200
)

faceted_time_series_plot2(out, sensor_coords,
  wind_data, as.POSIXct(start_time), as.POSIXct(end_time),
  output_dt
  )
}
