% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{interpolate_wind_data}
\alias{interpolate_wind_data}
\title{Resample wind_speeds and wind_directions to the simulation resolution by interpolation}
\usage{
interpolate_wind_data(wind_speeds, wind_directions, sim_start, sim_end, puff_dt)
}
\arguments{
\item{wind_speeds}{A list of float values of wind speeds in m/s at each time stamp}

\item{wind_directions}{A list of float values of wind directions in degrees at each time stamp following
the conventional definition: 0 -> wind blowing from North, 90 -> E, 180 -> S, 270 -> W}

\item{sim_start}{Date & time stamps of simulation start time}

\item{sim_end}{Date & time stamps of simulation end time}

\item{puff_dt}{A scalar time interval between two puffs}
}
\value{
Quantities corresponding to the conversion direction
}
\description{
Resample wind_speeds and wind_directions to the simulation resolution by interpolation
}
\examples{
out <- interpolate_wind_data(c(2, 3), c(90, 180),
  "2024-01-01 00:00:00", "2024-01-01 01:00:00", 300
)
}
