% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_raceEthnicity.R
\docType{data}
\name{derived_raceEthnicity}
\alias{derived_raceEthnicity}
\title{Derived Patient Race and Ethnicity Data}
\format{
A tibble with 3,560
rows and columns:
\describe{
\item{who}{Patient ID}
\item{race}{Self-reported race. Options are "White", "Black", "Other",
and "Refused/missing".}
\item{is_hispanic}{Self-reported Hispanic/Latino ethnicity.}
\item{race_ethnicity}{Derived composite marker of race and ethnicity.}
}
}
\usage{
data(derived_raceEthnicity)
}
\description{
Summarize the patients' self-reported race and ethnicity into
four groups: "Non-Hispanic White", "Non-Hispanic Black", "Hispanic", and
"Other".
}
\details{
This data set contains a summary of self-reported race and ethnicity
in four levels. Of note, the "Other" category includes 2 participants who
marked "no" to the question of Hispanic/Latino ethnicity but refused to
answer their race. Also, the "Other" category includes 33 participants for
whom all information about race and ethnicity is missing. This data set is
a derived data set; the script used to create it is
\code{"scripts/create_raceEthnicity_20220816.R"}.
}
\keyword{datasets}
