% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographics.R
\docType{data}
\name{demographics}
\alias{demographics}
\title{Patient demographics}
\format{
A tibble with 3,560 rows and
9 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{age}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Age at intake \cr
}


}
\item{\strong{is_hispanic}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Hispanic heritage \cr
    \tab  \cr
   \emph{Levels:} \tab No; Yes \cr
}


}
\item{\strong{race}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Black) \cr
    \tab  \cr
   \emph{Description:} \tab Self-reported race \cr
    \tab  \cr
   \emph{Levels:} \tab Black, Other Refused/missing, White \cr
}


}
\item{\strong{job}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Full Time) \cr
    \tab  \cr
   \emph{Description:} \tab Employment status at intake \cr
    \tab  \cr
   \emph{Levels:} \tab "" = Not asked, "Full Time", "Missing" = Missing from intake data, "Part Time", "Student", "Unemployed" \cr
}


}
\item{\strong{is_living_stable}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Living stability \cr
    \tab  \cr
   \emph{Levels:} \tab No = Not a stable living condition; Yes = Has a stable living place \cr
}


}
\item{\strong{education}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = HS/GED) \cr
    \tab  \cr
   \emph{Description:} \tab Education level at intake \cr
    \tab  \cr
   \emph{Levels:} \tab "HS/GED" = High school graduate or GED, "Less than HS" = Less High school and no GED, "Missing", More than HS = "Some education beyond high school" \cr
}


}
\item{\strong{marital}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Married or Partnered) \cr
    \tab  \cr
   \emph{Description:} \tab Marital status at intake \cr
    \tab  \cr
   \emph{Levels:} \tab "" = Not asked, "Married or Partnered", "Never married" "Not answered" = Not asked during at intake, "Separated/Divorced/Widowed" \cr
}


}
\item{\strong{is_male}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Sex (not gender) \cr
    \tab  \cr
   \emph{Levels:} \tab No = Not Male); Yes = Is male \cr
}


}
}
}
\usage{
demographics
}
\description{
This is baseline demographics. See the vignette
\href{../doc/harmonization.html}{Harmonization Information} for more details.
}
\keyword{datasets}
