% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{subset}
\alias{subset}
\alias{subset.distributional}
\alias{subset.compositional}
\alias{subset.counts}
\alias{subset.varietal}
\title{Get a subset of provenance data}
\usage{
\method{subset}{distributional}(x, subset = NULL, select = NULL, ...)

\method{subset}{compositional}(x, subset = NULL, components = NULL, select = NULL, ...)

\method{subset}{counts}(x, subset = NULL, components = NULL, select = NULL, ...)

\method{subset}{varietal}(x, subset = NULL, components = NULL, select = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{distributional},
\code{compositional}, \code{counts} or \code{varietal}.}

\item{subset}{logical expression indicating elements or rows to
keep: missing values are taken as false.}

\item{select}{a vector of sample names}

\item{...}{optional arguments for the generic subset function}

\item{components}{vector of categories (column names) to keep}
}
\value{
an object of the same class as \code{x}
}
\description{
Return a subset of provenance data according to some specified
indices
}
\examples{
data(Namib)
coast <- c("N1","N2","T8","T13","N12","N13")
ZTRcoast <- subset(Namib$HM,select=coast,components=c('gt','cpx','ep'))
DZcoast <- subset(Namib$DZ,select=coast)
summaryplot(ZTRcoast,KDEs(DZcoast),ncol=2)
}
\seealso{
\link{amalgamate}, \link{combine}
}
