/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.Cancellable;
import com.qarks.util.CancellableImpl;
import com.qarks.util.files.diff.Diff;
import com.qarks.util.files.diff.MergeResult;
import com.qarks.util.files.diff.ui.MergePanel;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class FileMergeMonitorDialog
extends JDialog
implements ActionListener {
    private MergeResult result = null;
    private MergeThread mergeThread;
    private Frame parentFrame;
    private JButton cancel;
    private Timer timer;
    private MergePanel editor;

    public FileMergeMonitorDialog(Window window, String string, String string2, String string3, boolean bl, MergePanel mergePanel) {
        super(window, ResourceManager.getString((Object)ResourceKeyDiff.MERGE_MONITOR), Dialog.ModalityType.APPLICATION_MODAL);
        this.init(string, string2, string3, bl, mergePanel);
    }

    private void init(String string, String string2, String string3, boolean bl, MergePanel mergePanel) {
        this.editor = mergePanel;
        this.timer = new Timer(500, this);
        this.timer.setRepeats(false);
        this.mergeThread = new MergeThread(string, string2, string3, bl);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.cancel.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.cancel, new GridBagConstraints());
        this.add(jPanel);
        jPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKeyDiff.MERGE_MONITOR_MESSAGE)), "North");
        jPanel.add((Component)jPanel2, "Center");
        this.setSize(300, 150);
    }

    public void start() {
        this.mergeThread.start();
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.timer) {
            if (this.result == null) {
                if (this.parentFrame != null && this.parentFrame.isShowing()) {
                    DialogUtilities.centerWindow(this, this.parentFrame);
                } else {
                    DialogUtilities.centerOnScreen(this);
                }
            }
        } else if (object == this.cancel) {
            this.mergeThread.cancel();
        }
    }

    private void onDiffEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileMergeMonitorDialog.this.dispose();
                FileMergeMonitorDialog.this.editor.setContent(FileMergeMonitorDialog.this.result);
            }
        });
    }

    private class MergeThread
    extends Thread {
        private Cancellable cancellable = new CancellableImpl();
        private String commonAncestorText;
        private String leftText;
        private String rightText;
        private boolean ignoreLeadingSpaces;

        public MergeThread(String string, String string2, String string3, boolean bl) {
            this.commonAncestorText = string;
            this.leftText = string2;
            this.rightText = string3;
            this.ignoreLeadingSpaces = bl;
        }

        public void cancel() {
            this.cancellable.cancel();
        }

        @Override
        public void run() {
            MergeResult mergeResult = Diff.merge(this.commonAncestorText, this.leftText, this.rightText, this.cancellable, this.ignoreLeadingSpaces);
            if (!this.cancellable.isCancelled()) {
                FileMergeMonitorDialog.this.result = mergeResult;
                if (FileMergeMonitorDialog.this.isShowing()) {
                    try {
                        Thread.sleep(800L);
                    }
                    catch (Exception exception) {}
                }
            } else {
                FileMergeMonitorDialog.this.result = Diff.quickMerge(this.commonAncestorText, this.leftText, this.rightText, this.ignoreLeadingSpaces);
            }
            FileMergeMonitorDialog.this.onDiffEnded();
        }
    }
}

