% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quorum.R
\name{reached_quorum_total}
\alias{reached_quorum_total}
\title{Check if parties reached the quorum for all votes}
\usage{
reached_quorum_total(votes_matrix, quorum_total)
}
\arguments{
\item{votes_matrix}{votes matrix}

\item{quorum_total}{Vote threshold a party must reach for all votes cast.
Used as fraction of total votes if less than 1, otherwise
as number of votes. Must be greater than 0.}
}
\value{
Logical vector with length equal to the number of lists/parties (\code{votes_matrix}
rows) showing whether they reached the quorum or not.
}
\description{
Base implementation, used by \code{\link[=quorum_functions]{quorum_functions}}.
}
\note{
Votes are not weighted across districts. This is relevant if the quorum threshold is the
minimal number of \emph{voters} (either as percentage or absolute value). In this case, use
\code{\link[=weight_votes_matrix]{weight_votes_matrix()}} before calculating the quorum.
}
\examples{
(vm = matrix(c(239, 10, 308, 398, 20, 925), nrow = 3))
reached_quorum_total(vm, 35)
}
\seealso{
\code{\link[=reached_quorum_any_district]{reached_quorum_any_district()}}
}
