% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize_data.R
\name{organize_data}
\alias{organize_data}
\title{Organize data for estimation (internal helper)}
\usage{
organize_data(
  .dataframe,
  .structure,
  .estimand,
  .remove_ties,
  .att_choose,
  .lev_choose,
  .att_notchoose,
  .lev_notchoose
)
}
\arguments{
\item{.dataframe}{A tibble/data frame from \code{\link{reshape_projoint}()},
containing columns like \code{id}, \code{task}, \code{profile}, \code{selected},
\code{agree} (if repeated), and attribute columns named \code{att1}, \code{att2}, ...
that store \code{level_id}s (e.g., \code{"att1:level2"}).}

\item{.structure}{Either \code{"profile_level"} or \code{"choice_level"}.}

\item{.estimand}{Either \code{"mm"} or \code{"amce"}.}

\item{.remove_ties}{Logical; if \code{TRUE} (default) remove tied responses
in profile-level setups (keeps tasks where exactly one profile is selected).}

\item{.att_choose}{Attribute ID for the “chosen” side (e.g., \code{"att3"}).}

\item{.lev_choose}{Level ID(s) for the chosen side (e.g., \code{"level2"} for
profile-level; vector of level IDs for choice-level).}

\item{.att_notchoose}{Attribute ID for the “not chosen” side (choice-level only).}

\item{.lev_notchoose}{Level ID(s) for the not-chosen side (choice-level only).}
}
\value{
A named list with two tibbles:
\itemize{
  \item \code{$data_for_estimand}: rows restricted and reshaped to the
        requested estimand/QOI. For profile-level, one row per respondent–task–profile
        where the target level is present (ties optionally removed). For choice-level,
        one row per respondent–task with paired information for profiles 1 and 2,
        restricted to the requested attribute-level pair(s).
  \item \code{$data_for_irr}: one row per respondent with columns \code{id},
        \code{agree} (if available), and any detected weight/cluster hints
        (columns matching \code{"my_weight|my_cluster|^weights?$|^clusters?$"}).
}
}
\description{
Prepares tidy inputs for MM/AMCE estimation and IRR handling.
Called inside \code{pj_estimate()} after reshaping to respondent–task–profile.
}
\keyword{internal}
