% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_bounds.R
\name{pre_bounds}
\alias{pre_bounds}
\title{Run pre-treatment bounds.}
\usage{
pre_bounds(formula, data, moderator, conf_level = 0.95, outcome_mono = 1L)
}
\arguments{
\item{formula}{A formula with syntax \code{y ~ t}, where \code{y} is the
(unquoted) name of the outcome and \code{t} is the (unquoted) name of the treatment.}

\item{data}{A data.frame containing variables in the formula, moderator, and covariates arguments.}

\item{moderator}{A one-sided formuala with syntax \code{~ d}, where \code{d}
is the (unquoted) name of the  moderator variable for the CATE.}

\item{conf_level}{A numeric indicating the confidence level for the bootstrap
confidence intervals.}

\item{outcome_mono}{A integer indicating the direction of the priming
monotonicity assumption. The default value \code{1} indicates that asking the
moderator question in the pre-test moves outcomes in a positive direction
for all units. The value \code{-1} indicates it moves outcomes in a negative
direction for all units.}
}
\value{
A list object containing bounds.
}
\description{
Run pre-treatment bounds.
}
\examples{
data(delponte)
pre_bounds(
  formula = angry_bin ~ t_commonality,
   data = delponte,
  moderator = ~ itaid_bin
)
}
